
using System;
namespace Zumero
{
    internal class ZumeroClientImplementation : IZumeroClientImplementation
    {
        public virtual void Sync(
                string fileName,
                string cipherKey,
                string serverUrl,
                string dbfile,
                string authScheme,
                string user,
                string password
                )
        {
            throw new NotImplementedException("This method must be overridden by the subclass");
        }

	    public virtual void Sync(
				string fileName,
				string cipherKey,
				string serverUrl,
				string dbfile,
				string authScheme,
				string user,
				string password,
				ZumeroClient.callback_progress_handler callback
				)
	    {
		    throw new NotImplementedException("This method must be overridden by the subclass");
	    }

	    public virtual void Sync(
				string fileName,
				string cipherKey,
				string serverUrl,
				string dbfile,
				string authScheme,
				string user,
				string password,
				string jsOptions,
				out int syncId,
				ZumeroClient.callback_progress_handler callback
				)
	    {
		    throw new NotImplementedException("This method must be overridden by the subclass");
	    }

	    public virtual bool SyncQuarantine(
                string fileName,
                string cipherKey,
                long qid,
                string serverUrl,
                string dbfile,
                string authScheme,
                string user,
                string password
                )
        {
            throw new NotImplementedException("This method must be overridden by the subclass");
        }


        public virtual bool SyncQuarantine(
                    string fileName,
                    string cipherKey,
                    long qid,
                    string serverUrl,
                    string dbfile,
                    string authScheme,
                    string user,
                    string password,
                    string jsOptions
                    )
        {
            throw new NotImplementedException("This method must be overridden by the subclass");
        }

        public virtual long QuarantineSinceLastSync(
                string fileName,
                string cipherKey
                )
        {
            throw new NotImplementedException("This method must be overridden by the subclass");
        }

        public virtual long QuarantineSinceLastSync(
                string fileName,
                string cipherKey,
                string jsOptions
                )
        {
            throw new NotImplementedException("This method must be overridden by the subclass");
        }

        public virtual void DeleteQuarantine(
                string fileName,
                string cipherKey,
                long qid
                )
        {
            throw new NotImplementedException("This method must be overridden by the subclass");
        }

        public virtual void DeleteQuarantine(
                string fileName,
                string cipherKey,
                long qid,
                string jsOptions
                )
        {
            throw new NotImplementedException("This method must be overridden by the subclass");
        }

	public virtual void Cancel(
                int cancellationToken
                )
        {
            throw new NotImplementedException("This method must be overridden by the subclass");
        }
    };

}

