package com.zumero.internal;

import java.io.InputStream;
import java.io.FilterInputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.Thread;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

//import android.util.Log;

public class ZumeroUtils {
	public static String exceptionStacktraceToString(Exception e)
	{
    		ByteArrayOutputStream baos = new ByteArrayOutputStream();
    		PrintStream ps = new PrintStream(baos);
    		e.printStackTrace(ps);
    		ps.close();
    		return baos.toString();
	}
     /**
     * This input stream won't read() after the underlying stream is exhausted.
     * https://code.google.com/p/android/issues/detail?id=14562
     */
    static final class DoneHandlerInputStream extends FilterInputStream {
        private boolean done;

        public DoneHandlerInputStream(InputStream stream) {
            super(stream);
        }

        @Override public int read(byte[] bytes, int offset, int count) throws IOException {
            if (!done && bytes != null) {
                int result = super.read(bytes, offset, count);
                if (result != -1) {
                    return result;
                }
            }
            done = true;
            return -1;
        }
    }

	public static ZumeroHTTPResponse DoNetworkCall(String URL, String method,
			String password, String filterBase, String pathToInputFile, String pathToOutputFile, long contextPtr) {
		URL url;
		ZumeroHTTPResponse response = new ZumeroHTTPResponse();
		response.setJavaExceptionString(null);
		
		try{
			HttpURLConnection outercon = null;
			ExecutorService executor = Executors.newSingleThreadExecutor();
			
			System.setProperty("http.keepAlive", "false");
			
			try {
				url = new URL(URL);
			} catch (MalformedURLException m) {
				m.printStackTrace();
				response.setJavaExceptionString(exceptionStacktraceToString(m));
				response.setStatusCode(1<<8);
				return response;
			}
	
			
			try {
				byte[] readbuff = new byte[10000];
	
				final HttpURLConnection con = (HttpURLConnection) url.openConnection();
				outercon = con;
				if (password != null)
					con.addRequestProperty("X-Zumero-Password", password);
				if (filterBase != null)
					con.addRequestProperty("X-Zumero-Filter-Base", filterBase);
				//con.setRequestProperty("Connection", "close");
				con.setRequestProperty("Accept-Encoding", "identity");
				con.setRequestMethod(method);
				if (pathToOutputFile != null)
					con.setDoInput(true);
	
				//Log.v("Zumero_network", "url is " + URL);
				//Log.v("Zumero_network", "java context " + contextPtr);
				//Log.v("Zumero_network", "input file is " + pathToInputFile);
				//Log.v("Zumero_network", "output file is " + pathToOutputFile);
				if (pathToInputFile != null) {
					int readCount = 0;
					File f = new File(pathToInputFile);
					f.createNewFile();
					con.setDoOutput(true);
					long length = f.length();
				//Log.v("Zumero_network", "input file is " + length + " bytes");
					con.setFixedLengthStreamingMode((int) length);
					BufferedInputStream fis = new BufferedInputStream(
							new FileInputStream(f));
					BufferedOutputStream bos = new BufferedOutputStream(
							con.getOutputStream());
					long bytesSoFar = 0;
					if (contextPtr != 0 && native_callback(contextPtr, 2, 0, length) != 0)
						return response;
					long nextNotificationBytes = 0;
					while ((readCount = fis.read(readbuff)) >= 0) {
						bos.write(readbuff, 0, readCount);
						bytesSoFar += readCount;
						if (bytesSoFar >= nextNotificationBytes)
						{
							if (contextPtr != 0 && native_callback(contextPtr, 2, bytesSoFar, length) != 0)
								return response;
							nextNotificationBytes += 80000;
							if (nextNotificationBytes > length)
								nextNotificationBytes = length;
						}
					}
					bos.flush();
					bos.close();
					fis.close();
				}
	
				if (contextPtr != 0 && native_callback(contextPtr, 3, 0, 0) != 0)
					return response;
				//Log.v("Zumero_network", "calling getResponseCode");
				Future<Integer> future = executor.submit(new Callable<Integer>()
				{
					@Override
					public Integer call() throws IOException
					{
						return con.getResponseCode();
					}
				});
				while(!future.isDone()) {
					if (contextPtr != 0 && native_callback(contextPtr, 3, 0, 0) != 0) {
						future.cancel(true);
						return response;
					}
					Thread.sleep(300);
				}
				int statusCode = future.get();
				response.setStatusCode(statusCode);
				//Log.v("Zumero_network", "Called setStatusCode to " + statusCode);
	
				//Log.e("Zumero_network", "response status " + statusCode);
				Map<String, List<String>> headers = con.getHeaderFields();
				if (headers.containsKey("X-Zumero-Error-Code"))
					response.setErrorCode(con.getHeaderFieldInt(
							"X-Zumero-Error-Code", 0 /* defaultValue */));
				//Log.e("Zumero_network", "Zumero  error code " + response.getErrorCode());
				//if (headers.containsKey("X-Zumero-Partial"))
					//response.setPartial(Long.parseLong(con
							//.getHeaderField("X-Zumero-Partial")));
				//response.setErrorCode(123);
				
				if (pathToOutputFile != null) {
				//Log.e("Zumero_network", "content length " + con.getContentLength());
					int readCount = 0;
					File fo = new File(pathToOutputFile);
					fo.createNewFile();
					long length = con.getContentLength();
					if (length > 0) {
				//Log.e("Zumero_network", "writing output");
						BufferedOutputStream bos = new BufferedOutputStream(
							new FileOutputStream(fo));
						BufferedInputStream fis = null;
						if (statusCode >= 200 && statusCode <= 300) {
							fis = new BufferedInputStream(//new DoneHandlerInputStream(
								con.getInputStream());//);
						} else {
							fis = new BufferedInputStream(//new DoneHandlerInputStream(
								con.getErrorStream());//);
						}
	
						long bytesSoFar = 0;
						if (contextPtr != 0 && native_callback(contextPtr, 4, 0, length) != 0)
							return response;
						long nextNotificationBytes = 0;
						while ((readCount = fis.read(readbuff)) >= 0) {
				//Log.e("Zumero_network", "writing " + readCount + " bytes of output");
							bos.write(readbuff, 0, readCount);
							bytesSoFar += readCount;
							if (bytesSoFar >= nextNotificationBytes)
							{
								if (contextPtr != 0 && native_callback(contextPtr, 4, bytesSoFar, length) != 0)
									return response;
								nextNotificationBytes += 80000;
								if (nextNotificationBytes > length)
									nextNotificationBytes = length;
							}
						}
						bos.flush();
						bos.close();
						fis.close();
					}
				}
			} catch (java.net.ConnectException e) {
				response.setStatusCode(456);
				e.printStackTrace();
				response.setJavaExceptionString(exceptionStacktraceToString(e));
				//Log.e("Zumero_network", e.getMessage());
				//Log.e("Zumero_network", "Failed to connect to " + url.toExternalForm(), e);
			} catch (IOException e) {
				//Log.e("Zumero_network", "Checking for 401");
				//Some different messages are: No authentication challenges found (in Jelly Bean)
				//or Received authentication challenge is null (in Gingerbread)
				e.printStackTrace();
				if (e != null && e.getMessage() != null && e.getMessage().contains("authentication challenge"))
				{
					response.setStatusCode(401);
					return response;
				}
				//Log.e("Zumero_network", e.getMessage());
				//Log.e("Zumero_network", "Failed to sync to " + url.toExternalForm(), e);
				response.setJavaExceptionString(exceptionStacktraceToString(e));
				throw e;
			} finally {
				if (outercon != null)
					outercon.disconnect();
			}
		}
		catch (Exception e) {
			response.setStatusCode(1);
			e.printStackTrace();
			response.setJavaExceptionString(exceptionStacktraceToString(e));
		}
		return response;
	}

	native static int native_callback(long contextPtr, int phase, long uBytesSoFar, long uBytesTotal);
}
