/*
** Copyright 2013-2026 Zumero, LLC
** All rights reserved. 
 */

// IMPORTANT!!!! Do not change the package name, as this
// class is referenced by full package path from JNI.
package com.zumero;

public class ZumeroException extends RuntimeException {
	public ZumeroException() {}
	/**
	 * 
	 */
	private static final long serialVersionUID = -1568579958434623155L;

	String _message;
	public ZumeroException(String message) {
		super(message);
		_message = message;
	}
	public int getErrCode() {
		if (this.getMessage().indexOf(":") >= 0)
			return Integer.parseInt(this.getMessage().substring(0, this.getMessage().indexOf(":")));
		else
			return 0;
	}
	@Override
	public String getMessage() {
		if (this._message.indexOf("|") >= 0)
			return this._message.substring(0, this._message.indexOf("|"));
		else
			return super.getMessage();
	}
	
	public String getDetailedMessage() {
		if (this._message.indexOf("|") >= 0)
			return this._message.substring(this._message.indexOf("|") + 1);
		else
			return super.getMessage();
	}
}
