/*
** Copyright 2013-2026 Zumero, LLC
** All rights reserved. 
 */

// IMPORTANT!!!! Do not change the package name, as this
// class is referenced by full package path from JNI.
package com.zumero;

/**
 * An interface which you can use to get status from a ZumeroClient.sync() call.
 */
public interface SyncProgressListener
{
   public final static int PHASE_PREPARING = 1;
   public final static int PHASE_UPLOADING = 2;
   public final static int PHASE_WAITING_FOR_RESPONSE = 3;
   public final static int PHASE_DOWNLOADING = 4;
   public final static int PHASE_APPLYING = 5;
   public void onSyncProgress(int cancellationToken, int phase, long bytesSoFar, long bytesTotal);
}
