package com.zumero.zumerosync;

import com.zumero.SyncProgressListener;
import com.zumero.ZumeroClient;
import com.zumero.ZumeroException;

import android.os.AsyncTask;
import android.os.Bundle;
import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.DialogInterface.OnCancelListener;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.view.Menu;
import android.view.View;
import android.view.View.OnClickListener;
import android.webkit.JavascriptInterface;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.CompoundButton.OnCheckedChangeListener;
import android.widget.EditText;
import android.widget.TextView;

import java.io.File;

public class SyncActivity extends Activity {

	private Button syncButton;
	private EditText urlText;
	private EditText dbfileText;
	private EditText schemeText;
	private EditText userText;
	private EditText passwordText;
	private CheckBox authCheckbox;
	private String fullPath;
	private TextView outputText;
	protected int cancel_token;

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_sync);
		
		outputText = (TextView)findViewById(R.id.outputText);
		
		syncButton = (Button)findViewById(R.id.myButton);
		urlText = (EditText)findViewById(R.id.serverText);
		dbfileText = (EditText)findViewById(R.id.dbfileText);
		schemeText = (EditText)findViewById(R.id.schemeText);
		userText = (EditText)findViewById(R.id.userText);
		passwordText = (EditText)findViewById(R.id.passwordText);
		authCheckbox = (CheckBox)findViewById(R.id.authCheckBox);
		final ProgressDialog prog = new ProgressDialog(this);
		
		prog.setOnCancelListener(new OnCancelListener() {
			
			@Override
			public void onCancel(DialogInterface dialog) {
				ZumeroClient.cancel(SyncActivity.this.cancel_token);
			}
		});
		//Get the full path to the database object.
		File f = this.getDatabasePath("basicSyncTest");
        fullPath = f.getAbsolutePath();
        try
        {
        	f.getParentFile().mkdirs();
        	if (f.exists())
        		f.delete();
        }
        catch (Exception e)
        {
        }

		authCheckbox.setOnCheckedChangeListener(new OnCheckedChangeListener() {
			
			@Override
			public void onCheckedChanged(CompoundButton arg0, boolean arg1) {
				SyncActivity.this.schemeText.setEnabled(arg1);
				SyncActivity.this.userText.setEnabled(arg1);
				SyncActivity.this.passwordText.setEnabled(arg1);
			}
		});
		syncButton.setOnClickListener(new OnClickListener() {
	
			@Override
			public void onClick(View v) {
				final String server = SyncActivity.this.urlText.getText().toString();
				final String dbfile = SyncActivity.this.dbfileText.getText().toString();
				final String scheme = SyncActivity.this.schemeText.getText().toString();
				final String user = SyncActivity.this.userText.getText().toString();
				final String password = SyncActivity.this.passwordText.getText().toString();
				final boolean authChecked = SyncActivity.this.authCheckbox.isChecked();
				new AsyncTask<Void, Void, String>() {

					@Override
					protected String doInBackground(Void... params) {
						try
                        {
							File f = new File(fullPath);
							f.delete();
                        }
                        catch(Exception e)
                        {
                        }

						
						SyncProgressListener listener = new SyncProgressListener() {
							
							@Override
							public void onSyncProgress(int cancellationToken, final int phase,
									final long bytesSoFar, final long bytesTotal) {
								SyncActivity.this.cancel_token = cancellationToken;
								SyncActivity.this.runOnUiThread(new Runnable() {
									
									@Override
									public void run() {
										String message = "";
										if (phase == SyncProgressListener.PHASE_PREPARING)
											message = "Preparing";
										else if (phase == SyncProgressListener.PHASE_UPLOADING)
											message = "Uploading " + bytesSoFar + " of " + bytesTotal;
										else if (phase == SyncProgressListener.PHASE_WAITING_FOR_RESPONSE)
											message = "Waiting for response";
										else if (phase == SyncProgressListener.PHASE_DOWNLOADING)
											message = "Downloading " + bytesSoFar + " of " + bytesTotal;
										else if (phase == SyncProgressListener.PHASE_APPLYING)
											message = "Applying";
										
										if (phase == SyncProgressListener.PHASE_UPLOADING || phase == SyncProgressListener.PHASE_DOWNLOADING)
										{
											if (bytesSoFar == 0)
												prog.setMax((int)bytesTotal);
											prog.setProgress((int)bytesSoFar);
										}
										
										prog.setMessage(message);
										
									}
								});
								
								
							}
						};
						try
						{
							if (authChecked)
								ZumeroClient.sync(SyncActivity.this, fullPath, null, server, dbfile, scheme, user, password, listener);
							else
								ZumeroClient.sync(SyncActivity.this, fullPath, null, server, dbfile, null, null, null, listener);
						}
						catch (ZumeroException ex)
						{
							return ex.getMessage();
						}


						//Save the sync vaules
						SharedPreferences.Editor ed = getSharedPreferences ("default", Context.MODE_PRIVATE).edit();
                        ed.putString ("server", server);
                        ed.putString ("dbfile", dbfile);
                        ed.putBoolean ("authenticate", authChecked);
                        ed.putString ("scheme", scheme);
                        ed.putString ("user", user);
                        ed.putString ("password", password);
                        ed.apply ();
                        
                        
                        //Build the output string
                        StringBuilder b = new StringBuilder();
                        
                        SQLiteDatabase db = SQLiteDatabase.openDatabase(fullPath, null, SQLiteDatabase.OPEN_READONLY);
                        Cursor c1 = db.rawQuery("SELECT name from sqlite_master WHERE type = 'table' and name NOT LIKE '%$%';", null);
                        
                        if (c1.moveToFirst())
                        {
                        	int tableCount = 0;
                        	do {
                        		tableCount++;
                        		int rowCount = 0;
                        		String tableName = c1.getString(0);
                        		Cursor c2 = db.rawQuery("SELECT COUNT(*) from [" + tableName + "];", null);
                        		if (c2.moveToFirst()) {
                        			rowCount = c2.getInt(0);
                        		}
                        		b.append("\t" + tableName + " -- " + rowCount + " row" + ((rowCount == 1) ? "" : "s") + "\n");
                        		c2.close();
                        	} while (c1.moveToNext());
                        	c1.close();
                        	
                        	return "Sync pulled down " + tableCount + " table" + ((tableCount == 1) ? "" : "s") + ":\n\n" + b.toString();
                        }

						return "";
					}

					@Override
					protected void onPostExecute(String result) {
						outputText.setText(result);
						prog.hide();
					}
					
					@Override
					protected void onPreExecute() {
						prog.show();
					}
				}.execute(null, null); 
			}
		});
		
		//Restore the previously used values.
        SharedPreferences sp = getSharedPreferences ("default", Context.MODE_PRIVATE);
        urlText.setText(sp.getString ("server", "http://:8080"));
        dbfileText.setText(sp.getString ("dbfile", ""));
        schemeText.setText(sp.getString ("scheme", "{\"scheme_type\":\"default\"}"));
        userText.setText(sp.getString ("user", ""));
        passwordText.setText(sp.getString ("password", ""));
        authCheckbox.setChecked(sp.getBoolean ("authenticate", false));
        
        schemeText.setEnabled(authCheckbox.isChecked());
        userText.setEnabled(authCheckbox.isChecked());
        passwordText.setEnabled(authCheckbox.isChecked());
	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		// Inflate the menu; this adds items to the action bar if it is present.
		return true;
	}

}

