/*
 * Decompiled with CFR 0.152.
 */
package com.zumero.internal;

import com.zumero.internal.ZumeroHTTPResponse;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class ZumeroUtils {
    public static String exceptionStacktraceToString(Exception e) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        e.printStackTrace(ps);
        ps.close();
        return baos.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ZumeroHTTPResponse DoNetworkCall(String URL2, String method, String password, String filterBase, String pathToInputFile, String pathToOutputFile, long contextPtr) {
        ZumeroHTTPResponse response = new ZumeroHTTPResponse();
        response.setJavaExceptionString(null);
        try {
            URL url;
            HttpURLConnection outercon = null;
            ExecutorService executor = Executors.newSingleThreadExecutor();
            System.setProperty("http.keepAlive", "false");
            try {
                url = new URL(URL2);
            }
            catch (MalformedURLException m) {
                m.printStackTrace();
                response.setJavaExceptionString(ZumeroUtils.exceptionStacktraceToString(m));
                response.setStatusCode(256);
                return response;
            }
            try {
                Object f;
                HttpURLConnection con;
                byte[] readbuff = new byte[10000];
                outercon = con = (HttpURLConnection)url.openConnection();
                if (password != null) {
                    con.addRequestProperty("X-Zumero-Password", password);
                }
                if (filterBase != null) {
                    con.addRequestProperty("X-Zumero-Filter-Base", filterBase);
                }
                con.setRequestProperty("Accept-Encoding", "identity");
                con.setRequestMethod(method);
                if (pathToOutputFile != null) {
                    con.setDoInput(true);
                }
                if (pathToInputFile != null) {
                    int readCount = 0;
                    f = new File(pathToInputFile);
                    ((File)f).createNewFile();
                    con.setDoOutput(true);
                    long length = ((File)f).length();
                    con.setFixedLengthStreamingMode((int)length);
                    BufferedInputStream fis = new BufferedInputStream(new FileInputStream((File)f));
                    BufferedOutputStream bos = new BufferedOutputStream(con.getOutputStream());
                    long bytesSoFar = 0L;
                    if (contextPtr != 0L && ZumeroUtils.native_callback(contextPtr, 2, 0L, length) != 0) {
                        ZumeroHTTPResponse zumeroHTTPResponse = response;
                        return zumeroHTTPResponse;
                    }
                    long nextNotificationBytes = 0L;
                    while ((readCount = fis.read(readbuff)) >= 0) {
                        bos.write(readbuff, 0, readCount);
                        if ((bytesSoFar += (long)readCount) < nextNotificationBytes) continue;
                        if (contextPtr != 0L && ZumeroUtils.native_callback(contextPtr, 2, bytesSoFar, length) != 0) {
                            ZumeroHTTPResponse zumeroHTTPResponse = response;
                            return zumeroHTTPResponse;
                        }
                        if ((nextNotificationBytes += 80000L) <= length) continue;
                        nextNotificationBytes = length;
                    }
                    bos.flush();
                    bos.close();
                    fis.close();
                }
                if (contextPtr != 0L && ZumeroUtils.native_callback(contextPtr, 3, 0L, 0L) != 0) {
                    ZumeroHTTPResponse readCount = response;
                    return readCount;
                }
                Future<Integer> future = executor.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws IOException {
                        return con.getResponseCode();
                    }
                });
                while (!future.isDone()) {
                    if (contextPtr != 0L && ZumeroUtils.native_callback(contextPtr, 3, 0L, 0L) != 0) {
                        future.cancel(true);
                        f = response;
                        return f;
                    }
                    Thread.sleep(300L);
                }
                int statusCode = future.get();
                response.setStatusCode(statusCode);
                Map<String, List<String>> headers = con.getHeaderFields();
                if (headers.containsKey("X-Zumero-Error-Code")) {
                    response.setErrorCode(con.getHeaderFieldInt("X-Zumero-Error-Code", 0));
                }
                if (pathToOutputFile == null) return response;
                int readCount = 0;
                File fo = new File(pathToOutputFile);
                fo.createNewFile();
                long length = con.getContentLength();
                if (length <= 0L) return response;
                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(fo));
                BufferedInputStream fis = null;
                fis = statusCode >= 200 && statusCode <= 300 ? new BufferedInputStream(con.getInputStream()) : new BufferedInputStream(con.getErrorStream());
                long bytesSoFar = 0L;
                if (contextPtr != 0L && ZumeroUtils.native_callback(contextPtr, 4, 0L, length) != 0) {
                    ZumeroHTTPResponse zumeroHTTPResponse = response;
                    return zumeroHTTPResponse;
                }
                long nextNotificationBytes = 0L;
                while ((readCount = fis.read(readbuff)) >= 0) {
                    bos.write(readbuff, 0, readCount);
                    if ((bytesSoFar += (long)readCount) < nextNotificationBytes) continue;
                    if (contextPtr != 0L && ZumeroUtils.native_callback(contextPtr, 4, bytesSoFar, length) != 0) {
                        ZumeroHTTPResponse zumeroHTTPResponse = response;
                        return zumeroHTTPResponse;
                    }
                    if ((nextNotificationBytes += 80000L) <= length) continue;
                    nextNotificationBytes = length;
                }
                bos.flush();
                bos.close();
                fis.close();
                return response;
            }
            catch (ConnectException e) {
                response.setStatusCode(456);
                e.printStackTrace();
                response.setJavaExceptionString(ZumeroUtils.exceptionStacktraceToString(e));
                return response;
            }
            catch (IOException e) {
                e.printStackTrace();
                if (e != null && e.getMessage() != null && e.getMessage().contains("authentication challenge")) {
                    response.setStatusCode(401);
                    ZumeroHTTPResponse zumeroHTTPResponse = response;
                    return zumeroHTTPResponse;
                }
                response.setJavaExceptionString(ZumeroUtils.exceptionStacktraceToString(e));
                throw e;
            }
            finally {
                if (outercon != null) {
                    outercon.disconnect();
                }
            }
        }
        catch (Exception e) {
            response.setStatusCode(1);
            e.printStackTrace();
            response.setJavaExceptionString(ZumeroUtils.exceptionStacktraceToString(e));
        }
        return response;
    }

    static native int native_callback(long var0, int var2, long var3, long var5);

    static final class DoneHandlerInputStream
    extends FilterInputStream {
        private boolean done;

        public DoneHandlerInputStream(InputStream stream) {
            super(stream);
        }

        public int read(byte[] bytes, int offset, int count) throws IOException {
            int result;
            if (!this.done && bytes != null && (result = super.read(bytes, offset, count)) != -1) {
                return result;
            }
            this.done = true;
            return -1;
        }
    }
}

