/*
 * Decompiled with CFR 0.152.
 */
package com.zumero.internal;

import android.database.Cursor;
import android.database.sqlite.SQLiteStatement;
import android.util.Log;
import com.zumero.internal.ZumeroDatabase;
import com.zumero.internal.ZumeroLongHolder;
import com.zumero.internal.ZumeroStringHolder;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class ZumeroStatement {
    public ZumeroDatabase _db = null;
    public String _sql = null;
    public SQLiteStatement _stmt = null;
    public Cursor _cursor = null;
    public boolean _haveAlreadyStepped = false;
    public ArrayList<String> _argsArray = new ArrayList();

    public ZumeroStatement(ZumeroDatabase db, String sql) {
        this._db = db;
        this._sql = sql;
        if (!this._sql.toLowerCase().startsWith("select") && !this._sql.toLowerCase().startsWith("pragma")) {
            this._stmt = this._db._db.compileStatement(sql);
        }
    }

    public static int reset(ZumeroStatement stmt) throws Exception {
        try {
            if (stmt._cursor != null) {
                stmt._cursor.close();
                stmt._cursor = null;
            }
            if (stmt._stmt != null) {
                stmt._stmt.clearBindings();
            }
            stmt._argsArray.clear();
            return 0;
        }
        catch (Exception e) {
            return ZumeroDatabase.HandleException(stmt._db, e);
        }
    }

    public static int step_for_long(ZumeroStatement stmt, ZumeroLongHolder outputHolder) {
        try {
            outputHolder.val = stmt._stmt.simpleQueryForLong();
            return 0;
        }
        catch (Exception e) {
            return ZumeroDatabase.HandleException(stmt._db, e);
        }
    }

    public static int step_for_text(ZumeroStatement stmt, ZumeroStringHolder outputHolder) {
        try {
            outputHolder.val = stmt._stmt.simpleQueryForString();
            return 0;
        }
        catch (Exception e) {
            return ZumeroDatabase.HandleException(stmt._db, e);
        }
    }

    public static void dumpDatabase(String tag, ZumeroStatement stmt) {
        int i;
        int colCount;
        Cursor c2;
        String tableName;
        String type;
        Log.v((String)tag, (String)"------------------------------- ");
        Log.v((String)tag, (String)stmt._sql);
        Cursor c1 = stmt._db._db.rawQuery("SELECT name, type, sql FROM sqlite_master", new String[0]);
        while (c1.moveToNext()) {
            type = c1.getString(1);
            Log.v((String)tag, (String)("==== " + type + " " + c1.getString(0)));
            if (!type.contains("table") && !type.contains("view")) continue;
            tableName = c1.getString(0);
            c2 = stmt._db._db.rawQuery("SELECT * FROM " + tableName, new String[0]);
            while (c2.moveToNext()) {
                colCount = c2.getColumnCount();
                for (i = 0; i < colCount; ++i) {
                    Log.v((String)tag, (String)(type + " " + tableName + "column " + c2.getColumnName(i) + " value " + (c2.getType(i) == 4 ? "blob" : c2.getString(i))));
                }
            }
            c2.close();
        }
        c1.close();
        c1 = stmt._db._db.rawQuery("SELECT name, type, sql FROM sqlite_temp_master", new String[0]);
        while (c1.moveToNext()) {
            type = c1.getString(1);
            if (!type.contains("table") && !type.contains("view")) continue;
            Log.v((String)tag, (String)("==== " + type + " " + c1.getString(0)));
            tableName = c1.getString(0);
            c2 = stmt._db._db.rawQuery("SELECT * FROM " + tableName, new String[0]);
            while (c2.moveToNext()) {
                colCount = c2.getColumnCount();
                for (i = 0; i < colCount; ++i) {
                    Log.v((String)tag, (String)(type + " " + tableName + " column " + c2.getColumnName(i) + " value " + (c2.isNull(i) ? "FOR REALLY REAL, IT'S NULL" : (c2.getType(i) == 4 ? "blob" : c2.getString(i)))));
                }
            }
            c2.close();
        }
        c1.close();
        Log.v((String)tag, (String)"------------------------------- ");
    }

    public static int step(ZumeroStatement stmt) throws Exception {
        try {
            int return_code = 1;
            if (stmt._stmt != null) {
                stmt._stmt.execute();
                return_code = 101;
            } else if (stmt._cursor == null) {
                stmt._cursor = stmt._db._db.rawQuery(stmt._sql, stmt._argsArray.toArray(new String[stmt._argsArray.size()]));
                return_code = stmt._cursor.moveToFirst() ? 100 : 101;
            } else {
                return_code = stmt._cursor.moveToNext() ? 100 : 101;
            }
            return return_code;
        }
        catch (Exception e) {
            return ZumeroDatabase.HandleException(stmt._db, e);
        }
    }

    public static int bind_int(ZumeroStatement stmt, int colNum, int val) {
        try {
            if (stmt._stmt != null) {
                stmt._stmt.bindLong(colNum, (long)val);
            } else {
                ZumeroStatement.growArgsArray(stmt, colNum);
                stmt._argsArray.set(colNum - 1, Long.toString(val));
            }
            return 0;
        }
        catch (Exception e) {
            return ZumeroDatabase.HandleException(stmt._db, e);
        }
    }

    public static void growArgsArray(ZumeroStatement stmt, int colNum) {
        while (colNum > stmt._argsArray.size()) {
            stmt._argsArray.add(null);
        }
    }

    public static int bind_int64(ZumeroStatement stmt, int colNum, long val) {
        try {
            if (stmt._stmt != null) {
                stmt._stmt.bindLong(colNum, val);
            } else {
                ZumeroStatement.growArgsArray(stmt, colNum);
                stmt._argsArray.set(colNum - 1, Long.toString(val));
            }
            return 0;
        }
        catch (Exception e) {
            return ZumeroDatabase.HandleException(stmt._db, e);
        }
    }

    public static int bind_double(ZumeroStatement stmt, int colNum, double val) {
        try {
            if (stmt._stmt != null) {
                stmt._stmt.bindDouble(colNum, val);
            } else {
                ZumeroStatement.growArgsArray(stmt, colNum);
                stmt._argsArray.set(colNum - 1, Double.toString(val));
            }
            return 0;
        }
        catch (Exception e) {
            return ZumeroDatabase.HandleException(stmt._db, e);
        }
    }

    public static int bind_null(ZumeroStatement stmt, int colNum) {
        try {
            if (stmt._stmt != null) {
                stmt._stmt.bindNull(colNum);
            } else {
                ZumeroStatement.growArgsArray(stmt, colNum);
                stmt._argsArray.set(colNum - 1, null);
            }
            return 0;
        }
        catch (Exception e) {
            return ZumeroDatabase.HandleException(stmt._db, e);
        }
    }

    public static int bind_text(ZumeroStatement stmt, int colNum, String val) {
        try {
            if (stmt._stmt != null) {
                stmt._stmt.bindString(colNum, val);
            } else {
                ZumeroStatement.growArgsArray(stmt, colNum);
                stmt._argsArray.set(colNum - 1, val);
            }
            return 0;
        }
        catch (Exception e) {
            return ZumeroDatabase.HandleException(stmt._db, e);
        }
    }

    public static int bind_zeroblob(ZumeroStatement stmt, int colNum, int num) {
        byte[] emptyArray = new byte[num];
        try {
            if (stmt._stmt == null) {
                return 1;
            }
            stmt._stmt.bindBlob(colNum, emptyArray);
            return 0;
        }
        catch (Exception e) {
            return ZumeroDatabase.HandleException(stmt._db, e);
        }
    }

    public static int bind_blob(ZumeroStatement stmt, int colNum, byte[] blob) {
        try {
            if (stmt._stmt != null) {
                if (blob == null) {
                    stmt._stmt.bindNull(colNum);
                } else {
                    stmt._stmt.bindBlob(colNum, blob);
                }
            } else {
                return 1;
            }
            return 0;
        }
        catch (Exception e) {
            return ZumeroDatabase.HandleException(stmt._db, e);
        }
    }

    public static int bind_blob(ZumeroStatement stmt, int colNum, ByteBuffer blob) {
        try {
            byte[] b = new byte[blob.limit()];
            blob.rewind();
            blob.get(b);
            if (stmt._stmt == null) {
                return 1;
            }
            stmt._stmt.bindBlob(colNum, b);
            return 0;
        }
        catch (Exception e) {
            return ZumeroDatabase.HandleException(stmt._db, e);
        }
    }

    public static int clear_bindings(ZumeroStatement stmt) {
        try {
            if (stmt._stmt != null) {
                stmt._stmt.clearBindings();
            }
            stmt._argsArray.clear();
            return 0;
        }
        catch (Exception e) {
            return ZumeroDatabase.HandleException(stmt._db, e);
        }
    }

    public static int finalize(ZumeroStatement stmt) {
        try {
            if (stmt._cursor != null) {
                stmt._cursor.close();
                stmt._cursor = null;
            }
            if (stmt._stmt != null) {
                stmt._stmt.clearBindings();
                stmt._stmt.close();
                stmt._cursor = null;
            }
            return 0;
        }
        catch (Exception e) {
            return ZumeroDatabase.HandleException(stmt._db, e);
        }
    }

    public static int column_bytes(ZumeroStatement stmt, int colNum) {
        try {
            if (ZumeroStatement.column_type(stmt, colNum) == 4) {
                byte[] blob = stmt._cursor.getBlob(colNum);
                return blob.length;
            }
            if (ZumeroStatement.column_type(stmt, colNum) == 3) {
                String val = stmt._cursor.getString(colNum);
                return val.length();
            }
            return 0;
        }
        catch (Exception e) {
            ZumeroDatabase.HandleException(stmt._db, e);
            return 0;
        }
    }

    public static ByteBuffer column_blob(ZumeroStatement stmt, int colNum) {
        try {
            if (stmt._cursor != null) {
                byte[] blob = stmt._cursor.getBlob(colNum);
                if (blob != null) {
                    ByteBuffer b = ByteBuffer.allocateDirect(blob.length);
                    b.put(blob);
                    b.rewind();
                    return b;
                }
                return null;
            }
        }
        catch (Exception e) {
            ZumeroDatabase.HandleException(stmt._db, e);
        }
        return null;
    }

    public static int column_int(ZumeroStatement stmt, int colNum) {
        try {
            if (stmt._cursor != null) {
                return stmt._cursor.getInt(colNum);
            }
        }
        catch (Exception e) {
            ZumeroDatabase.HandleException(stmt._db, e);
        }
        return 0;
    }

    public static long column_int64(ZumeroStatement stmt, int colNum) {
        try {
            if (stmt._cursor != null) {
                return stmt._cursor.getLong(colNum);
            }
        }
        catch (Exception e) {
            ZumeroDatabase.HandleException(stmt._db, e);
        }
        return 0L;
    }

    public static double column_double(ZumeroStatement stmt, int colNum) {
        try {
            if (stmt._cursor != null) {
                return stmt._cursor.getDouble(colNum);
            }
        }
        catch (Exception e) {
            ZumeroDatabase.HandleException(stmt._db, e);
        }
        return 0.0;
    }

    public static String column_text(ZumeroStatement stmt, int colNum) {
        try {
            if (stmt._cursor != null) {
                return stmt._cursor.getString(colNum);
            }
        }
        catch (Exception e) {
            ZumeroDatabase.HandleException(stmt._db, e);
        }
        return null;
    }

    public static String column_name(ZumeroStatement stmt, int colNum) {
        try {
            if (stmt._cursor != null) {
                return stmt._cursor.getColumnName(colNum);
            }
        }
        catch (Exception e) {
            ZumeroDatabase.HandleException(stmt._db, e);
        }
        return null;
    }

    private static void print_value(ZumeroStatement stmt, int colNum) {
        int type = stmt._cursor.getType(colNum);
        switch (type) {
            case 4: {
                return;
            }
            case 2: {
                return;
            }
            case 1: {
                return;
            }
            case 3: {
                return;
            }
            case 0: {
                return;
            }
        }
    }

    public static int column_type(ZumeroStatement stmt, int colNum) {
        try {
            if (stmt._cursor != null) {
                int type = stmt._cursor.getType(colNum);
                int colCount = stmt._cursor.getColumnCount();
                switch (type) {
                    case 4: {
                        return 4;
                    }
                    case 2: {
                        return 2;
                    }
                    case 1: {
                        return 1;
                    }
                    case 3: {
                        return 3;
                    }
                    case 0: {
                        return 5;
                    }
                }
            }
        }
        catch (Exception e) {
            ZumeroDatabase.HandleException(stmt._db, e);
        }
        return -1;
    }

    public static int column_count(ZumeroStatement stmt) {
        try {
            if (stmt._cursor != null) {
                return stmt._cursor.getColumnCount();
            }
        }
        catch (Exception e) {
            ZumeroDatabase.HandleException(stmt._db, e);
        }
        return -1;
    }
}

