/*
 * Decompiled with CFR 0.152.
 */
package com.zumero.internal;

import android.database.Cursor;
import android.database.sqlite.SQLiteAbortException;
import android.database.sqlite.SQLiteAccessPermException;
import android.database.sqlite.SQLiteBindOrColumnIndexOutOfRangeException;
import android.database.sqlite.SQLiteBlobTooBigException;
import android.database.sqlite.SQLiteCantOpenDatabaseException;
import android.database.sqlite.SQLiteConstraintException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDatabaseCorruptException;
import android.database.sqlite.SQLiteDatabaseLockedException;
import android.database.sqlite.SQLiteDatatypeMismatchException;
import android.database.sqlite.SQLiteDiskIOException;
import android.database.sqlite.SQLiteDoneException;
import android.database.sqlite.SQLiteFullException;
import android.database.sqlite.SQLiteMisuseException;
import android.database.sqlite.SQLiteOutOfMemoryException;
import android.database.sqlite.SQLiteReadOnlyDatabaseException;
import android.database.sqlite.SQLiteStatement;
import android.database.sqlite.SQLiteTableLockedException;
import android.os.ParcelFileDescriptor;
import android.util.Log;
import com.zumero.internal.ZumeroDatabaseHolder;
import com.zumero.internal.ZumeroLongHolder;
import com.zumero.internal.ZumeroStatement;
import com.zumero.internal.ZumeroStatementHolder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;

public class ZumeroDatabase {
    private static final int SQLITE_OPEN_READONLY = 1;
    private static final int SQLITE_OPEN_READWRITE = 2;
    private static final int SQLITE_OPEN_CREATE = 4;
    private static final int SQLITE_OPEN_DELETEONCLOSE = 8;
    private static final int SQLITE_OPEN_EXCLUSIVE = 16;
    private static final int SQLITE_OPEN_AUTOPROXY = 32;
    private static final int SQLITE_OPEN_URI = 64;
    private static final int SQLITE_OPEN_MEMORY = 128;
    private static final int SQLITE_OPEN_MAIN_DB = 256;
    private static final int SQLITE_OPEN_TEMP_DB = 512;
    private static final int SQLITE_OPEN_TRANSIENT_DB = 1024;
    private static final int SQLITE_OPEN_MAIN_JOURNAL = 2048;
    private static final int SQLITE_OPEN_TEMP_JOURNAL = 4096;
    private static final int SQLITE_OPEN_SUBJOURNAL = 8192;
    private static final int SQLITE_OPEN_MASTER_JOURNAL = 16384;
    private static final int SQLITE_OPEN_NOMUTEX = 32768;
    private static final int SQLITE_OPEN_FULLMUTEX = 65536;
    private static final int SQLITE_OPEN_SHAREDCACHE = 131072;
    private static final int SQLITE_OPEN_PRIVATECACHE = 262144;
    private static final int SQLITE_OPEN_WAL = 524288;
    public static final int SQLITE_OK = 0;
    public static final int SQLITE_ERROR = 1;
    public static final int SQLITE_INTERNAL = 2;
    public static final int SQLITE_PERM = 3;
    public static final int SQLITE_ABORT = 4;
    public static final int SQLITE_BUSY = 5;
    public static final int SQLITE_LOCKED = 6;
    public static final int SQLITE_NOMEM = 7;
    public static final int SQLITE_READONLY = 8;
    public static final int SQLITE_INTERRUPT = 9;
    public static final int SQLITE_IOERR = 10;
    public static final int SQLITE_CORRUPT = 11;
    public static final int SQLITE_NOTFOUND = 12;
    public static final int SQLITE_FULL = 13;
    public static final int SQLITE_CANTOPEN = 14;
    public static final int SQLITE_PROTOCOL = 15;
    public static final int SQLITE_EMPTY = 16;
    public static final int SQLITE_SCHEMA = 17;
    public static final int SQLITE_TOOBIG = 18;
    public static final int SQLITE_CONSTRAINT = 19;
    public static final int SQLITE_MISMATCH = 20;
    public static final int SQLITE_MISUSE = 21;
    public static final int SQLITE_NOLFS = 22;
    public static final int SQLITE_AUTH = 23;
    public static final int SQLITE_FORMAT = 24;
    public static final int SQLITE_RANGE = 25;
    public static final int SQLITE_NOTADB = 26;
    public static final int SQLITE_NOTICE = 27;
    public static final int SQLITE_WARNING = 28;
    public static final int SQLITE_ROW = 100;
    public static final int SQLITE_DONE = 101;
    public static final int SQLITE_INTEGER = 1;
    public static final int SQLITE_FLOAT = 2;
    public static final int SQLITE_BLOB = 4;
    public static final int SQLITE_NULL = 5;
    public static final int SQLITE_TEXT = 3;
    public SQLiteDatabase _db = null;
    public String LastErr = "";
    public String _fileName = "";

    public static int HandleException(ZumeroDatabase db, Exception e) {
        if (db != null) {
            db.LastErr = e.toString();
        }
        Log.e((String)"ZUMERO", (String)"exception", (Throwable)e);
        if (e instanceof SQLiteConstraintException) {
            return 19;
        }
        if (e instanceof SQLiteAbortException) {
            return 4;
        }
        if (e instanceof SQLiteAccessPermException) {
            return 3;
        }
        if (e instanceof SQLiteBindOrColumnIndexOutOfRangeException) {
            return 25;
        }
        if (e instanceof SQLiteBlobTooBigException) {
            return 18;
        }
        if (e instanceof SQLiteCantOpenDatabaseException) {
            return 14;
        }
        if (e instanceof SQLiteDatabaseCorruptException) {
            return 11;
        }
        if (e instanceof SQLiteDatabaseLockedException) {
            return 5;
        }
        if (e instanceof SQLiteDatatypeMismatchException) {
            return 20;
        }
        if (e instanceof SQLiteDiskIOException) {
            return 10;
        }
        if (e instanceof SQLiteDoneException) {
            return 1;
        }
        if (e instanceof SQLiteFullException) {
            return 13;
        }
        if (e instanceof SQLiteMisuseException) {
            return 21;
        }
        if (e instanceof SQLiteOutOfMemoryException) {
            return 7;
        }
        if (e instanceof SQLiteReadOnlyDatabaseException) {
            return 8;
        }
        if (e instanceof SQLiteTableLockedException) {
            return 6;
        }
        return 1;
    }

    public static int open_v2(String fileName, ZumeroDatabaseHolder outputHolder, int flags) throws Exception {
        try {
            SQLiteDatabase sqdb;
            int javaflags = 0;
            if ((flags & 4) != 0) {
                javaflags |= 0x10000000;
            }
            if ((flags & 2) != 0) {
                javaflags |= 0;
            }
            if ((flags & 1) != 0) {
                javaflags |= 0;
            }
            if ((flags & 0x80000) != 0) {
                javaflags |= 0x20000000;
            }
            outputHolder.db = new ZumeroDatabase();
            outputHolder.db._db = sqdb = SQLiteDatabase.openDatabase((String)fileName, null, (int)javaflags);
            outputHolder.db._fileName = fileName;
            return 0;
        }
        catch (Exception e) {
            return ZumeroDatabase.HandleException(outputHolder.db, e);
        }
    }

    public static int prepare_v2(ZumeroDatabase db, String sql, ZumeroStatementHolder outputHolder) throws Exception {
        try {
            outputHolder.stmt = new ZumeroStatement(db, sql);
        }
        catch (Exception e) {
            return ZumeroDatabase.HandleException(db, e);
        }
        return 0;
    }

    public static int close(ZumeroDatabase db) throws Exception {
        try {
            if (db != null && db._db != null) {
                db._db.close();
            }
        }
        catch (Exception e) {
            return ZumeroDatabase.HandleException(db, e);
        }
        return 0;
    }

    public static int changes(ZumeroDatabase db) throws Exception {
        try {
            SQLiteStatement stmt = db._db.compileStatement("SELECT changes();");
            long val = stmt.simpleQueryForLong();
            stmt.close();
            return (int)val;
        }
        catch (Exception e) {
            ZumeroDatabase.HandleException(db, e);
            return 0;
        }
    }

    public static long last_insert_rowid(ZumeroDatabase db) throws Exception {
        try {
            SQLiteStatement stmt = db._db.compileStatement("SELECT last_insert_rowid();");
            long val = stmt.simpleQueryForLong();
            stmt.close();
            return val;
        }
        catch (Exception e) {
            ZumeroDatabase.HandleException(db, e);
            return 0L;
        }
    }

    public static String errmsg(ZumeroDatabase db) throws Exception {
        return db.LastErr;
    }

    public static int transfer_value(ZumeroStatement stmt_from, ZumeroStatement stmt_to, int colNum_from, int colNum_to) {
        int i = colNum_from;
        int rc = -1;
        int colType = ZumeroStatement.column_type(stmt_from, i);
        switch (colType) {
            case 4: {
                ByteBuffer val = ZumeroStatement.column_blob(stmt_from, i);
                if (val == null) {
                    rc = ZumeroStatement.bind_blob(stmt_to, colNum_to, ByteBuffer.allocate(0));
                    break;
                }
                rc = ZumeroStatement.bind_blob(stmt_to, colNum_to, val);
                break;
            }
            case 2: {
                double val = ZumeroStatement.column_double(stmt_from, i);
                rc = ZumeroStatement.bind_double(stmt_to, colNum_to, val);
                break;
            }
            case 1: {
                long val = ZumeroStatement.column_int64(stmt_from, i);
                rc = ZumeroStatement.bind_int64(stmt_to, colNum_to, val);
                break;
            }
            case 3: {
                String val = ZumeroStatement.column_text(stmt_from, i);
                rc = ZumeroStatement.bind_text(stmt_to, colNum_to, val);
                break;
            }
            case 5: {
                rc = ZumeroStatement.bind_null(stmt_to, colNum_to);
            }
        }
        return rc;
    }

    private static boolean int_array_contains_int(int[] array, int search) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != search) continue;
            return true;
        }
        return false;
    }

    public static void loop_stmt_to_stmt_import_export(ZumeroDatabase db_from, ZumeroDatabase db_to, String SelectQueryRowid, String SelectQueryData, String[] columns, int[] largeStringColumnIndexes, int[] largeBlobColumnIndexes, String InsertStatementQuery, ZumeroLongHolder rc_from, ZumeroLongHolder rc_to) throws Exception {
        int rc = -1;
        Object colTypes = null;
        Hashtable<String, ColumnStreamer> streamers = new Hashtable<String, ColumnStreamer>();
        ArrayList<String> regularColumns = new ArrayList<String>();
        for (int i = 0; i < columns.length; ++i) {
            if (ZumeroDatabase.int_array_contains_int(largeStringColumnIndexes, i)) {
                ((Dictionary)streamers).put(columns[i], new ColumnStreamer(db_from._db, SelectQueryData, columns[i], true));
                continue;
            }
            if (ZumeroDatabase.int_array_contains_int(largeBlobColumnIndexes, i)) {
                ((Dictionary)streamers).put(columns[i], new ColumnStreamer(db_from._db, SelectQueryData, columns[i], false));
                continue;
            }
            regularColumns.add(columns[i]);
        }
        Cursor c_rowid = db_from._db.rawQuery(SelectQueryRowid, new String[0]);
        c_rowid.moveToFirst();
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < regularColumns.size(); ++i) {
            if (i > 0) {
                b.append(",");
            }
            if (((String)regularColumns.get(i)).startsWith("--zss--")) {
                b.append(((String)regularColumns.get(i)).replace("--zss--", ""));
                continue;
            }
            b.append("[" + (String)regularColumns.get(i) + "]");
        }
        String regColumnsString = b.toString();
        String modifiedQuery = SelectQueryData.replace("{{{ZUMERO_COLUMN_TOKEN}}}", regColumnsString);
        ZumeroStatementHolder stmt_from_holder = new ZumeroStatementHolder();
        rc = ZumeroDatabase.prepare_v2(db_from, modifiedQuery, stmt_from_holder);
        ZumeroStatement stmt_from = stmt_from_holder.stmt;
        if (rc != 0) {
            rc_from.val = rc;
            return;
        }
        ZumeroStatementHolder stmt_to_holder = new ZumeroStatementHolder();
        rc = ZumeroDatabase.prepare_v2(db_to, InsertStatementQuery, stmt_to_holder);
        ZumeroStatement stmt_to = stmt_to_holder.stmt;
        if (rc != 0) {
            rc_to.val = rc;
            return;
        }
        while (!c_rowid.isAfterLast()) {
            int currentRowid = c_rowid.getInt(0);
            ZumeroStatement.bind_int64(stmt_from, 1, currentRowid);
            while ((rc = ZumeroStatement.step(stmt_from)) == 100) {
                int regularColumnIndex = 0;
                rc = ZumeroStatement.clear_bindings(stmt_to);
                if (rc != 0) {
                    rc_to.val = rc;
                    return;
                }
                boolean regColumnIndex = false;
                for (int i = 0; i < columns.length; ++i) {
                    int rcsub;
                    if (ZumeroDatabase.int_array_contains_int(largeStringColumnIndexes, i)) {
                        String longString = ((ColumnStreamer)((Dictionary)streamers).get(columns[i])).getFullString(currentRowid);
                        rcsub = ZumeroStatement.bind_text(stmt_to, i + 1, longString);
                        if (rcsub == 0) continue;
                        rc_to.val = rcsub;
                        return;
                    }
                    if (ZumeroDatabase.int_array_contains_int(largeBlobColumnIndexes, i)) {
                        byte[] longBlob = ((ColumnStreamer)((Dictionary)streamers).get(columns[i])).getFullBlob(currentRowid);
                        rcsub = ZumeroStatement.bind_blob(stmt_to, i + 1, longBlob);
                        if (rcsub == 0) continue;
                        rc_to.val = rcsub;
                        return;
                    }
                    int rcsub2 = ZumeroDatabase.transfer_value(stmt_from, stmt_to, regularColumnIndex, i + 1);
                    ++regularColumnIndex;
                    if (rcsub2 == 0) continue;
                    rc_to.val = rcsub2;
                    return;
                }
                rc = ZumeroStatement.step(stmt_to);
                if (rc != 101) {
                    rc_to.val = rc;
                    return;
                }
                rc = ZumeroStatement.reset(stmt_to);
                if (rc == 0) continue;
                rc_to.val = rc;
                return;
            }
            if (rc != 101) {
                rc_from.val = rc;
            }
            if ((rc = ZumeroStatement.reset(stmt_from)) != 0) {
                rc_from.val = rc;
                return;
            }
            c_rowid.moveToNext();
        }
        c_rowid.close();
        ZumeroStatement.finalize(stmt_from);
        ZumeroStatement.finalize(stmt_to);
    }

    public static void loop_stmt_to_stmt(ZumeroStatement stmt_from, ZumeroStatement stmt_to, ZumeroLongHolder rc_from, ZumeroLongHolder rc_to) throws Exception {
        int rc = -1;
        Object colTypes = null;
        int count_columns = -1;
        int j = 0;
        while ((rc = ZumeroStatement.step(stmt_from)) == 100) {
            ++j;
            if (count_columns < 0) {
                count_columns = ZumeroStatement.column_count(stmt_from);
            }
            int i = 0;
            rc = ZumeroStatement.clear_bindings(stmt_to);
            if (rc != 0) {
                rc_to.val = rc;
                return;
            }
            for (i = 0; i < count_columns; ++i) {
                int rcsub = ZumeroDatabase.transfer_value(stmt_from, stmt_to, i, i + 1);
                if (rcsub == 0) continue;
                rc_to.val = rcsub;
                return;
            }
            rc = ZumeroStatement.step(stmt_to);
            if (rc != 101) {
                rc_to.val = rc;
                return;
            }
            rc = ZumeroStatement.reset(stmt_to);
            if (rc == 0) continue;
            rc_to.val = rc;
            return;
        }
        if (rc != 101) {
            rc_from.val = rc;
        }
    }

    public static int stmt_to_stmt(ZumeroStatement stmt_from, int beginFrom, ZumeroStatement stmt_to, int beginTo, int count) {
        int i = 0;
        int count_columns = ZumeroStatement.column_count(stmt_from);
        if (count < 0) {
            count = count_columns;
        }
        for (i = 0; i < count; ++i) {
            int rcsub = ZumeroDatabase.transfer_value(stmt_from, stmt_to, i + beginFrom, i + 1 + beginTo);
            if (rcsub == 0) continue;
            return rcsub;
        }
        return 0;
    }

    public static int fetch_blob_into_file(ZumeroDatabase db, String path, String table, String column, int rowid) {
        try {
            Cursor c = db._db.rawQuery("SELECT [" + column + "] FROM [" + table + "] where _rowid_ = ?", new String[]{Integer.toString(rowid)});
            if (c.moveToFirst()) {
                byte[] readbuff = new byte[3000];
                byte[] bytes = c.getBlob(0);
                File f = new File(path);
                f.createNewFile();
                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(f));
                bos.write(bytes, 0, bytes.length);
                bos.flush();
                bos.close();
            }
        }
        catch (Exception e) {
            ZumeroDatabase.HandleException(db, e);
            return 0;
        }
        return 0;
    }

    public static int insert_blob_from_file(ZumeroDatabase db, String path, String table, String column, int rowid) {
        try {
            File f = new File(path);
            byte[] bytes = new byte[(int)f.length()];
            BufferedInputStream buf = new BufferedInputStream(new FileInputStream(f));
            buf.read(bytes, 0, bytes.length);
            buf.close();
            SQLiteStatement stmt = db._db.compileStatement("UPDATE [" + table + "] SET [" + column + "] = ? WHERE _rowid_ = ?");
            stmt.bindBlob(1, bytes);
            stmt.bindLong(2, (long)rowid);
            stmt.execute();
            stmt.close();
        }
        catch (Exception e) {
            ZumeroDatabase.HandleException(db, e);
            return 0;
        }
        return 0;
    }

    private static class ColumnStreamer {
        private ArrayList<SQLiteStatement> preparedStatements = new ArrayList();
        private boolean _isStringColumn = false;
        private byte[] allBytes = null;
        private int bytesAtATime = 819200;
        private SQLiteDatabase _db = null;
        private String _origQuery = null;
        private String _column = null;
        private String _querycolumn = null;
        private SQLiteStatement _lengthStatement = null;

        public ColumnStreamer(SQLiteDatabase db, String query, String column, boolean isString) {
            this._isStringColumn = isString;
            this._db = db;
            this._origQuery = query;
            this._column = column;
            this._querycolumn = column;
            this._querycolumn = this._column.startsWith("--zss--") ? this._column.replace("--zss--", "") : "[" + this._column + "]";
        }

        private void resetAllStatements() {
            for (int i = 0; i < this.preparedStatements.size(); ++i) {
                this.preparedStatements.get(i).clearBindings();
            }
            if (this._lengthStatement != null) {
                this._lengthStatement.clearBindings();
            }
        }

        private SQLiteStatement getLengthStatement() {
            if (this._lengthStatement != null) {
                return this._lengthStatement;
            }
            String modifiedQuery = this._origQuery.replace("{{{ZUMERO_COLUMN_TOKEN}}}", "IFNULL(LENGTH( " + this._querycolumn + " ), -1) ");
            this._lengthStatement = this._db.compileStatement(modifiedQuery);
            return this._lengthStatement;
        }

        private SQLiteStatement getStatementForChunk(int chunkNum) {
            if (chunkNum < this.preparedStatements.size()) {
                return this.preparedStatements.get(chunkNum);
            }
            String modifiedQuery = this._isStringColumn ? this._origQuery.replace("{{{ZUMERO_COLUMN_TOKEN}}}", "substr(" + this._querycolumn + ", " + (this.bytesAtATime * chunkNum + 1) + ", " + this.bytesAtATime + ")") : this._origQuery.replace("{{{ZUMERO_COLUMN_TOKEN}}}", this._querycolumn);
            SQLiteStatement stmt = this._db.compileStatement(modifiedQuery);
            this.preparedStatements.add(stmt);
            return stmt;
        }

        public String getFullString(int rowid) {
            StringBuilder fullString = new StringBuilder();
            int iCurrentChunk = 0;
            int bytesRead = 0;
            do {
                SQLiteStatement statement = this.getStatementForChunk(iCurrentChunk);
                statement.bindLong(1, (long)rowid);
                String result = statement.simpleQueryForString();
                fullString.append(result);
                if (result == null) break;
                bytesRead = result.length();
                ++iCurrentChunk;
            } while (bytesRead == this.bytesAtATime);
            this.resetAllStatements();
            return fullString.toString();
        }

        public byte[] getFullBlob(int rowid) {
            SQLiteStatement statementLength = this.getLengthStatement();
            statementLength.bindLong(1, (long)rowid);
            long length = statementLength.simpleQueryForLong();
            if (length < 0L) {
                return null;
            }
            if (length == 0L) {
                return new byte[0];
            }
            SQLiteStatement statement = this.getStatementForChunk(0);
            statement.bindLong(1, (long)rowid);
            ParcelFileDescriptor pfd = statement.simpleQueryForBlobFileDescriptor();
            if (pfd == null) {
                return null;
            }
            FileInputStream stream = new FileInputStream(pfd.getFileDescriptor());
            byte[] blob = new byte[this.bytesAtATime];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                int rc = -1;
                while ((rc = stream.read(blob)) >= 0) {
                    baos.write(blob, 0, rc);
                }
            }
            catch (IOException io) {
                this.resetAllStatements();
                return null;
            }
            this.resetAllStatements();
            return baos.toByteArray();
        }

        public void closeStatements() {
            for (int i = 0; i < this.preparedStatements.size(); ++i) {
                this.preparedStatements.get(i).close();
            }
        }
    }
}

