/*
 * Decompiled with CFR 0.152.
 */
package com.zumero;

import android.content.Context;
import com.zumero.SyncProgressListener;

public class ZumeroClient {
    public static void sync(Context context, String databasePath, String encryptionKey, String serverURL, String dbFile, String authScheme, String username, String password) {
        ZumeroClient.sync(context, databasePath, encryptionKey, serverURL, dbFile, authScheme, username, password, null);
    }

    public static void sync(Context context, String databasePath, String encryptionKey, String serverURL, String dbFile, String authScheme, String username, String password, SyncProgressListener progListener) {
        ZumeroClient.sync(context, databasePath, encryptionKey, serverURL, dbFile, authScheme, username, password, null, null, progListener);
    }

    public static void sync(Context context, String databasePath, String encryptionKey, String serverURL, String dbFile, String authScheme, String username, String password, String jsOptions, SyncDetails details, SyncProgressListener progListener) {
        if (context == null) {
            throw new NullPointerException("A context must be provided to ZumeroClient.Sync");
        }
        if (databasePath == null) {
            throw new NullPointerException("A databasePath must be provided to ZumeroClient.Sync");
        }
        if (serverURL == null) {
            throw new NullPointerException("A serverURL must be provided to ZumeroClient.Sync");
        }
        if (dbFile == null) {
            throw new NullPointerException("A dbFile must be provided to ZumeroClient.Sync");
        }
        ZumeroClient.native_sync3(databasePath, encryptionKey, serverURL, dbFile, authScheme, username, password, context.getCacheDir().getAbsolutePath(), jsOptions, details, progListener);
    }

    public static long quarantineSinceLastSync(Context context, String databasePath, String encryptionKey, String jsOptions) {
        if (context == null) {
            throw new NullPointerException("A context must be provided to ZumeroClient.QuarantineSinceLastSync");
        }
        if (databasePath == null) {
            throw new NullPointerException("A databasePath must be provided to ZumeroClient.QuarantineSinceLastSync");
        }
        return ZumeroClient.native_quarantine_since_last_sync3(databasePath, encryptionKey, context.getCacheDir().getAbsolutePath(), jsOptions);
    }

    public static long quarantineSinceLastSync(Context context, String databasePath, String encryptionKey) {
        return ZumeroClient.quarantineSinceLastSync(context, databasePath, encryptionKey, null);
    }

    public static void syncQuarantine(Context context, String databasePath, String encryptionKey, long quarantineID, String serverURL, String dbFile, String authScheme, String username, String password) {
        ZumeroClient.syncQuarantine(context, databasePath, encryptionKey, quarantineID, serverURL, dbFile, authScheme, username, password, null, null, null);
    }

    public static void syncQuarantine(Context context, String databasePath, String encryptionKey, long quarantineID, String serverURL, String dbFile, String authScheme, String username, String password, String jsOptions, SyncDetails details, SyncProgressListener progListener) {
        if (context == null) {
            throw new NullPointerException("A context must be provided to ZumeroClient.SyncQuarantine");
        }
        if (databasePath == null) {
            throw new NullPointerException("A databasePath must be provided to ZumeroClient.SyncQuarantine");
        }
        if (serverURL == null) {
            throw new NullPointerException("A serverURL must be provided to ZumeroClient.SyncQuarantine");
        }
        if (dbFile == null) {
            throw new NullPointerException("A dbFile must be provided to ZumeroClient.SyncQuarantine");
        }
        ZumeroClient.native_sync_quarantine3(databasePath, encryptionKey, quarantineID, serverURL, dbFile, authScheme, username, password, context.getCacheDir().getAbsolutePath(), jsOptions, details, progListener);
    }

    public static void deleteQuarantine(Context context, String databasePath, String encryptionKey, long quarantineID) {
        ZumeroClient.deleteQuarantine(context, databasePath, encryptionKey, quarantineID, null);
    }

    public static void deleteQuarantine(Context context, String databasePath, String encryptionKey, long quarantineID, String jsOptions) {
        if (context == null) {
            throw new NullPointerException("A context must be provided to ZumeroClient.QuarantineSinceLastSync");
        }
        if (databasePath == null) {
            throw new NullPointerException("A databasePath must be provided to ZumeroClient.QuarantineSinceLastSync");
        }
        ZumeroClient.native_delete_quarantine3(databasePath, encryptionKey, quarantineID, jsOptions);
    }

    public static void cancel(int cancel_token) {
        ZumeroClient.native_cancel(cancel_token);
    }

    static native void native_sync(String var0, String var1, String var2, String var3, String var4, String var5, String var6, String var7);

    static native void native_sync2(String var0, String var1, String var2, String var3, String var4, String var5, String var6, String var7, SyncProgressListener var8);

    static native void native_sync3(String var0, String var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8, SyncDetails var9, SyncProgressListener var10);

    static native long native_quarantine_since_last_sync(String var0, String var1, String var2);

    static native long native_quarantine_since_last_sync3(String var0, String var1, String var2, String var3);

    static native void native_sync_quarantine(String var0, String var1, long var2, String var4, String var5, String var6, String var7, String var8, String var9);

    static native void native_sync_quarantine3(String var0, String var1, long var2, String var4, String var5, String var6, String var7, String var8, String var9, String var10, SyncDetails var11, SyncProgressListener var12);

    static native void native_delete_quarantine(String var0, String var1, long var2);

    static native void native_delete_quarantine3(String var0, String var1, long var2, String var4);

    static native void native_cancel(int var0);

    static {
        System.loadLibrary("zumero_sqlite_functions");
        System.loadLibrary("zumero_client_api");
        System.loadLibrary("zumero_jni");
    }

    public static class SyncDetails {
        public int syncId;
    }
}

